//
//  AdamemController.m
//  Adamem
//
//  Copyright 2008 Geoff Oltmans. All rights reserved.
//

#import "AdamemController.h"
#import "SDLMain.h"
#import "Coleco.h"


extern int PausePressed;
char cntDiskName[4][200];
char cntTapeName[4][200];

@implementation AdamemController

-(IBAction)togglePause:(id)x
{
	if (PausePressed) {
		PausePressed = 0;
		[pause setState:NSOffState];
	}
	else {
		PausePressed = 1;
		[pause setState:NSOnState];
	}
	if (DiskName[0]) {
		[diskA setTitle:[NSString stringWithFormat:@"Disk 1 - %s",DiskName[0]]];
	} else {
		[diskA setTitle:@"Disk 1"];
	}
	
		
}

-(IBAction)resetComputer:(id)x
{
	ResetColeco(0);
}
-(IBAction)resetGame:(id)x
{
	ResetColeco(1);
}

-(IBAction)setIFreq50:(id)x
{
	IFreq = 50;
}

-(IBAction)setIFreq60:(id)x
{
	IFreq = 60;
}

-(IBAction)attachDiskImage:(id)sender
{
	int disknum = [sender tag];
	NSOpenPanel *thePanel = [NSOpenPanel openPanel];
	NSArray *types = [NSArray arrayWithObjects:@"dsk", @"img", nil];
	
	[thePanel setAllowsMultipleSelection:NO];
    [thePanel setCanChooseFiles:YES];
    [thePanel setCanChooseDirectories:NO];
    [thePanel setTitle:@"Attach Disk Image"];    
    
    int result = [thePanel runModalForDirectory:nil file:nil types:types];
    if(result==NSOKButton) {
		DiskClose(disknum);
		strncpy(cntDiskName[disknum],[[thePanel filename] UTF8String],200);
		DiskName[disknum] = cntDiskName[disknum];
		DiskOpen(disknum);
    }    
	
}

-(IBAction)detachDiskImage:(id)sender
{

	int disknum = [sender tag];
	switch (disknum) {
		case 0:
			[diskA setTitle:@"Disk 1 - No disk"];
			
			break;
		case 1:
			break;
		case 2:
			break;
		case 3:
			break;
	}
	DiskClose(disknum);
}

-(IBAction)attachTapeImage:(id)sender
{
	int tapenum = [sender tag];
	NSOpenPanel *thePanel = [NSOpenPanel openPanel];
	NSArray *types = [NSArray arrayWithObjects:@"ddp", nil];
	
	[thePanel setAllowsMultipleSelection:NO];
    [thePanel setCanChooseFiles:YES];
    [thePanel setCanChooseDirectories:NO];
    [thePanel setTitle:@"Attach Tape Image"];    
    
    int result = [thePanel runModalForDirectory:nil file:nil types:types];
    if(result==NSOKButton) {
		TapeClose(tapenum);
		strncpy(cntTapeName[tapenum],[[thePanel filename] UTF8String],200);
		TapeName[tapenum] = cntTapeName[tapenum];
		TapeOpen(tapenum);
    }    
	
}

-(IBAction)detachTapeImage:(id)sender
{
	
	int tapenum = [sender tag];
	TapeClose(tapenum);
}

-(IBAction)fullScreen:(id)sender
{
	//[NSAlert alertWithMessageText:@"To return to windowed mode, press ALT-RETURN" defaultButton:@"OK"];
	setFullScreen(1);
}
@end
